function []=image_gen(Aproj_final,Vc_final,subcoords,mzaxis,PCnum,negate,cleangraph);

%This program will perform PCA imaging.  It will output two graphs.  The
%first is a heat map of a particular PC trend in your data.  The second is
%a mass spectral interpretation of the PC trend.  Warning:  The mass
%spectral interpretation of the PC trend is not always directly 
%interpretable (see Supporting Information of paper).

%INPUTS
%Aproj_final - The PC scores of the processed and aligned data.  This will 
%be an output of the mzPCA command.

%Vc_final - The spectral trends/principal components of the processed and
%aligned data. This will be an output of the mzPCA command.

%subcoords - These are the XY MALDI imaging coordinates for your subsection
%of relevant pixels you selected.  This was an output of the plotandselect
%command.

%mzaxis - This is your mass axis.

%PCnum - Replace this with a number corresponding to whichever PC you wish
%to image

%negate - This will be used to flip the heat map if the PC spectral trend
%is upside down.  Replace this with 'T' to flip the image.  Replace this
%with 'F' if you do not want to negate the image. PCs are calculated
%without a directional sense (positive or negative).  It is fully
%acceptable to flip their direction as the corresponding scores will invert
%from positive to negative (and vice versa).

%cleangraph - This will be used create a graph that is pretty for easier
%exporting.  If you replace this with 'T', it will remove all numbers,
%ticks, and make the background white.  If you replace this with 'F', the
%background will be white, but all the numbers/ticks will still be in
%place.

%create a heat map of your PC.  I use NaN instead of zeros to fill unused
%coordinates.
rows=max(subcoords(:,1));
columns=max(subcoords(:,2));
image1=NaN(rows,columns);
[a,b]=size(Aproj_final);
for x=1:b
    image1(subcoords(x,1),subcoords(x,2))=Aproj_final(PCnum,x);
end

%decide whether to negate or not your heat map
if (negate=='F')
figure
imagesc(1*image1')
shading interp
axis tight
elseif (negate=='T')
figure
imagesc(-1*image1')
axis tight
end

%decide whether or not to clean your graph and make it pretty for easier
%exporting
if (cleangraph=='T')
    grid off
set(gca, 'XTick', []);
set(gca, 'YTick', []);
set(gca, 'ZTick', []);
set(gca, 'XColor', 'white');
set(gca, 'YColor', 'white');
set(gca, 'ZColor', 'white');
set(gcf, 'color', 'white');
colorbar
h=colorbar;
set(h,'YTick',[])
elseif (cleangraph=='F')
set(gcf, 'color', 'white');
set(gca,'FontSize',16)
xlabel('X Coordinate','FontSize',16)
ylabel('Y Coordinate','FontSize',16)
colorbar
h=colorbar;
set(h,'fontsize',16);
set(gca,'ticklength',[0,0])
end

%decide whether or not to negate your PC loading:
if (negate=='F')
figure
plot(mzaxis,Vc_final(:,PCnum),'LineWidth',2)
xlabel('Mass to Charge Ratio (m/z)','FontSize',16)
set(gca,'FontSize',16)
set(gcf, 'color', 'white');
set(gca,'ytick',[])
set(gca,'yticklabel',[])
elseif (negate=='T')
figure
plot(mzaxis,-1*Vc_final(:,PCnum),'LineWidth',2)
xlabel('Mass to Charge Ratio (m/z)','FontSize',16)
set(gca,'FontSize',16)
set(gcf, 'color', 'white');
set(gca,'ytick',[])
set(gca,'yticklabel',[])
end
